<?php
    // Create Custom Messages
    function TS_VCSC_Team_Post_Messages($messages) {
		global $post, $post_ID;
		$post_type = get_post_type( $post_ID );
		$obj = get_post_type_object($post_type);
		$singular = $obj->labels->singular_name;
		$messages[$post_type] = array(
			0 => '', // Unused. Messages start at index 1.
			1 => sprintf( __($singular.' updated.')),
			2 => __('Custom field updated.'),
			3 => __('Custom field deleted.'),
			4 => __($singular.' updated.'),
			5 => isset($_GET['revision']) ? sprintf( __($singular.' restored to revision from %s'), wp_post_revision_title( (int) $_GET['revision'], false ) ) : false,
			6 => sprintf( __($singular.' published.')),
			7 => __('Page saved.'),
			8 => sprintf( __($singular.' submitted.')),
			9 => sprintf( __($singular.' scheduled for: <strong>%1$s</strong>.'), date_i18n( __('M j, Y @ G:i'), strtotime($post->post_date))),
			10 => sprintf( __($singular.' draft updated.')),
		);
		return $messages;
    }
	
    // Add Content for Contextual Help Section
    function TS_VCSC_Team_Post_HelpOld($contextual_help, $screen_id, $screen) { 
        if ( 'edit-ts_team' == $screen->id ) {
            $contextual_help = '<h2>Team Members</h2>
            <p>Team Members show the details and contact information for staff or group members that you want to provide to your visitors.</p> 
            <p>You can view/edit the details of each team member by clicking on its name, or you can perform bulk actions using the dropdown menu and selecting multiple items.</p>';
        } else if ('ts_team' == $screen->id) {
            $contextual_help = '<h2>Editing Team Members</h2>
            <p>This page allows you to view/modify team member details. Please make sure to fill out the available boxes with the appropriate details. Team Member information can only be used with the "Composium - WP Bakery Page Builder Extensions" plugin.</p>';
        }
        return $contextual_help;
    }
	function TS_VCSC_Team_Post_HelpNew() {
		$screen 				= get_current_screen();
        $screen_ids 			= array('edit-ts_team', 'ts_team');
		if (!in_array($screen->id, $screen_ids)) {
			return;
		}
		$screen->add_help_tab(
			array(
				'id'       		=> 'ts_team_help',
				'title'    		=> 'Team Members',
				'callback' 		=> function ($screen, $tab) {
					if ('edit-ts_team' == $screen->id) {
						echo '<p>Team Members show the details and contact information for staff or group members that you want to provide to your visitors.</p> 
                        <p>You can view/edit the details of each team member by clicking on its name, or you can perform bulk actions using the dropdown menu and selecting multiple items.</p>';
					} else if ('ts_team' == $screen->id) {
						echo '<p>This page allows you to view/modify team member details. Please make sure to fill out the available boxes with the appropriate details. Team Member information can only be used with the "Composium - WP Bakery Page Builder Extensions" plugin.</p>';
					}
				}
			)
		);
	}
	
	// Add Custom Metaboxes to Post Type
	function TS_VCSC_Team_CodeStar() {
		global $pagenow;		
		$screen 								= TS_VCSC_GetCurrentPostType();
		$prefixA 								= 'ts_vcsc_team_basic_';
		$prefixB 								= 'ts_vcsc_team_contact_';
		$prefixC								= 'ts_vcsc_team_social_';
		$prefixD								= 'ts_vcsc_team_skills_';
		$prefixE								= 'ts_vcsc_team_opening_';
		
		// Migration of Old Metadata for Existing Posts
		if (($screen == 'ts_team') && ($pagenow == 'post.php')) {
			$metaOld 							= array(
				// Section - Basic Information
				$prefixA . 'position', $prefixB . 'email', $prefixB . 'phone', $prefixB . 'cell', $prefixB . 'portfolio', $prefixB . 'portfoliolabel', $prefixB . 'other', $prefixB . 'otherlabel', $prefixB . 'skype',
				// Section - Business / Opening Hours
				$prefixD . 'symbol', $prefixD . 'symbolcolor', $prefixD . 'header', $prefixD . 'opening',
				// Section - Team Page Link
				$prefixA . 'dedicatedpage', $prefixA . 'dedicatedlink', $prefixA . 'dedicatedtarget', $prefixA . 'dedicatedicon', $prefixA . 'dedicatedcolor', $prefixA . 'dedicatedlabel', $prefixA . 'dedicatedtooltip', $prefixA . 'dedicatedtype',
				// Section - File Attachment
				$prefixA . 'buttonfile', $prefixA . 'buttonicon', $prefixA . 'buttoncolor', $prefixA . 'buttonlabel', $prefixA . 'buttontooltip', $prefixA . 'buttontype',
				// Section - Social Networks
				$prefixC . 'facebook', $prefixC . 'google', $prefixC . 'twitter', $prefixC . 'linkedin', $prefixC . 'xing', $prefixC . 'envato', $prefixC . 'rss', $prefixC . 'forrst', $prefixC . 'flickr', $prefixC . 'instagram', $prefixC . 'picasa', $prefixC . 'pinterest', $prefixC . 'vimeo', $prefixC . 'youtube',
				// Section - Skill Sets
				$prefixD . 'skillset',
			);
			$metaSwitch							= array($prefixA . 'dedicatedtarget',);
			$metaGallery						= array();
			$metaImage							= array();
			if (function_exists('TS_VCSC_Codestar_Migrate_Routine')){
				TS_VCSC_Codestar_Migrate_Routine(get_the_ID(), 'ts_team', $metaOld, $metaSwitch, $metaGallery, $metaImage, 'ts_vcsc_team_information', 0, 'ts_vcsc_team_migrated', false, false, false);
			}
		}
		
		if (($screen == 'ts_team') && ($pagenow == 'post-new.php' || $pagenow == 'post.php')) {
			// Define Available Button Types
			$TS_VCSC_Button_Types = array(
				// Default Color Buttons
				'ts-button-3d'													=> 'Standard / 3D - Square',
				'ts-button-3d ts-button-rounded'								=> 'Standard / 3D - Rounded',
				'ts-button-3d ts-button-pill'									=> 'Standard / 3D - Pill',
				'ts-button-default'												=> 'Standard / Default - Square',
				'ts-button-default glow'										=> 'Standard / Default - Square (Glow)',
				'ts-button-rounded ts-button-default'							=> 'Standard / Default - Rounded',
				'ts-button-rounded ts-button-default glow'						=> 'Standard / Default - Rounded (Glow)',
				'ts-button-pill ts-button-default'								=> 'Standard / Default - Pill',
				'ts-button-pill ts-button-default glow'							=> 'Standard / Default - Pill (Glow)',
				'ts-button-flat'												=> 'Standard / Flat - Square',
				'ts-button-flat glow'											=> 'Standard / Flat - Square (Glow)',
				'ts-button-rounded ts-button-flat'								=> 'Standard / Flat - Rounded',
				'ts-button-rounded ts-button-flat glow'							=> 'Standard / Flat - Rounded (Glow)',
				'ts-button-pill ts-button-flat'									=> 'Standard / Flat - Pill',
				'ts-button-pill ts-button-flat glow'							=> 'Standard / Flat - Pill (Glow)',
				// Primary Color Buttons
				'ts-button-3d-primary'											=> 'Primary / 3D - Square',
				'ts-button-3d-primary ts-button-rounded'						=> 'Primary / 3D - Rounded',
				'ts-button-3d-primary ts-button-pill'							=> 'Primary / 3D - Pill',
				'ts-button-default ts-button-primary'							=> 'Primary / Default - Square',
				'ts-button-default glow ts-button-primary'						=> 'Primary / Default - Square (Glow)',
				'ts-button-rounded-primary ts-button-default'					=> 'Primary / Default - Rounded',
				'ts-button-rounded-primary ts-button-default'					=> 'Primary / Default - Rounded (Glow)',
				'ts-button-pill ts-button-primary'								=> 'Primary / Default - Pill',
				'ts-button-pill ts-button-primary glow'							=> 'Primary / Default - Pill (Glow)',
				'ts-button-flat-primary'										=> 'Primary / Flat - Square',
				'ts-button-flat-primary glow'									=> 'Primary / Flat - Square (Glow)',
				'ts-button-rounded ts-button-flat-primary'						=> 'Primary / Flat - Rounded',
				'ts-button-rounded ts-button-flat-primary glow'					=> 'Primary / Flat - Rounded (Glow)',
				'ts-button-pill ts-button-flat-primary'							=> 'Primary / Flat - Pill',
				'ts-button-pill ts-button-flat-primary glow'					=> 'Primary / Flat - Pill (Glow)',
				// Action Color Buttons
				'ts-button-3d-action'											=> 'Action / 3D - Square',
				'ts-button-3d-action ts-button-rounded'							=> 'Action / 3D - Rounded',
				'ts-button-3d-action ts-button-pill'							=> 'Action / 3D - Pill',
				'ts-button-default ts-button-action'							=> 'Action / Default - Square',
				'ts-button-default glow ts-button-action'						=> 'Action / Default - Square (Glow)',
				'ts-button-rounded ts-button-default ts-button-action'			=> 'Action / Default - Rounded',
				'ts-button-rounded ts-button-default glow ts-button-action'		=> 'Action / Default - Rounded (Glow)',
				'ts-button-pill ts-button-default ts-button-action'				=> 'Action / Default - Pill',
				'ts-button-pill ts-button-default glow ts-button-action'		=> 'Action / Default - Pill (Glow)',
				'ts-button-flat-action'											=> 'Action / Flat - Square',
				'ts-button-flat-action glow'									=> 'Action / Flat - Square (Glow)',
				'ts-button-rounded ts-button-flat-action'						=> 'Action / Flat - Rounded',
				'ts-button-rounded ts-button-flat-action glow'					=> 'Action / Flat - Rounded (Glow)',
				'ts-button-pill ts-button-flat-action'							=> 'Action / Flat - Pill',
				'ts-button-pill ts-button-flat-action glow'						=> 'Action / Flat - Pill (Glow)',
				// Highlight Color Buttons
				'ts-button-3d-highlight'										=> 'Highlight / 3D - Square',
				'ts-button-3d-highlight ts-button-rounded'						=> 'Highlight / 3D - Rounded',
				'ts-button-3d-highlight ts-button-pill'							=> 'Highlight / 3D - Pill',
				'ts-button-default ts-button-highlight'							=> 'Highlight / Default - Square',
				'ts-button-default glow ts-button-highlight'					=> 'Highlight / Default - Square (Glow)',
				'ts-button-rounded ts-button-default ts-button-highlight'		=> 'Highlight / Default - Rounded',
				'ts-button-rounded ts-button-default glow ts-button-highlight'	=> 'Highlight / Default - Rounded (Glow)',
				'ts-button-pill ts-button-default ts-button-highlight'			=> 'Highlight / Default - Pill',
				'ts-button-pill ts-button-default glow ts-button-highlight'		=> 'Highlight / Default - Pill (Glow)',
				'ts-button-flat-highlight'										=> 'Highlight / Flat - Square',
				'ts-button-flat-highlight glow'									=> 'Highlight / Flat - Square (Glow)',
				'ts-button-rounded ts-button-flat-highlight'					=> 'Highlight / Flat - Rounded',
				'ts-button-rounded ts-button-flat-highlight glow'				=> 'Highlight / Flat - Rounded (Glow)',
				'ts-button-pill ts-button-flat-highlight'						=> 'Highlight / Flat - Pill',
				'ts-button-pill ts-button-flat-highlight glow'					=> 'Highlight / Flat - Pill (Glow)',
				// Caution Color Buttons
				'ts-button-3d-caution'											=> 'Caution / 3D - Square',
				'ts-button-3d-caution ts-button-rounded'						=> 'Caution / 3D - Rounded',
				'ts-button-3d-caution ts-button-pill'							=> 'Caution / 3D - Pill',
				'ts-button-default ts-button-caution'							=> 'Caution / Default - Square',
				'ts-button-default glow ts-button-caution'						=> 'Caution / Default - Square (Glow)',
				'ts-button-rounded ts-button-default ts-button-caution'			=> 'Caution / Default - Rounded',
				'ts-button-rounded ts-button-default glow ts-button-caution'	=> 'Caution / Default - Rounded (Glow)',
				'ts-button-pill ts-button-default ts-button-caution'			=> 'Caution / Default - Pill',
				'ts-button-pill ts-button-default glow ts-button-caution'		=> 'Caution / Default - Pill (Glow)',
				'ts-button-flat-caution'										=> 'Caution / Flat - Square',
				'ts-button-flat-caution glow'									=> 'Caution / Flat - Square (Glow)',
				'ts-button-rounded ts-button-flat-caution'						=> 'Caution / Flat - Rounded',
				'ts-button-rounded ts-button-flat-caution glow'					=> 'Caution / Flat - Rounded (Glow)',
				'ts-button-pill ts-button-flat-caution'							=> 'Caution / Flat - Pill',
				'ts-button-pill ts-button-flat-caution glow'					=> 'Caution / Flat - Pill (Glow)',
				// Royal Color Buttons
				'ts-button-3d-royal'											=> 'Royal / 3D - Square',
				'ts-button-3d-royal ts-button-rounded'							=> 'Royal / 3D - Rounded',
				'ts-button-3d-royal ts-button-pill'								=> 'Royal / 3D - Pill',
				'ts-button-default ts-button-royal'								=> 'Royal / Default - Square',
				'ts-button-default glow ts-button-royal'						=> 'Royal / Default - Square (Glow)',
				'ts-button-rounded ts-button-default ts-button-royal'			=> 'Royal / Default - Rounded',
				'ts-button-rounded ts-button-default glow ts-button-royal'		=> 'Royal / Default - Rounded (Glow)',
				'ts-button-pill ts-button-default ts-button-royal'				=> 'Royal / Default - Pill',
				'ts-button-pill ts-button-default glow ts-button-royal'			=> 'Royal / Default - Pill (Glow)',
				'ts-button-flat-royal'											=> 'Royal / Flat - Square',
				'ts-button-flat-royal glow'										=> 'Royal / Flat - Square (Glow)',
				'ts-button-rounded ts-button-flat-royal'						=> 'Royal / Flat - Rounded',
				'ts-button-rounded ts-button-flat-royal glow'					=> 'Royal / Flat - Rounded (Glow)',
				'ts-button-pill ts-button-flat-royal'							=> 'Royal / Flat - Pill',
				'ts-button-pill ts-button-flat-royal glow'						=> 'Royal / Flat - Pill (Glow)',
			);
	
			$availablePages 					= array();
			$availablePages['-1']				= 'No Page for Teammate';
			$availablePages['external'] 		= 'External Page Teammate';
			$availablePages						= $availablePages + TS_VCSC_GetPostOptions(array('post_type' => 'page', 'posts_per_page' => -1), true);
            
            if (class_exists('CSF')) {
                
                $prefix_page_opts           = 'ts_vcsc_custompost_migrated';
                
                CSF::createMetabox($prefix_page_opts, array(
                  'title'                   => 'Teammate Migration',
                  'post_type'               => 'ts_team',
                  'theme'                   => 'dark',
                  'priority'                => 'default',
                  'context'                 => 'side',
                  'show_restore'            => false,
                ));                
                CSF::createSection($prefix_page_opts, array(
                    'title'                 => 'Teammate Migration',
                    'icon'                  => 'fa fa-check-square-o',
                    'fields'                => array(
                        array(
                            'id'		    => 'ts_vcsc_team_migrated',
                            'type'    	    => 'inputhidden',
                            'title'		    => 'Migration Success:',
                            'default' 	    => 'true',
                        ),
                    )
                ));
                
                $prefix_page_opts               = 'ts_vcsc_team_information';
                
                CSF::createMetabox($prefix_page_opts, array(
                  'title'                       => 'Team Member Information',
                  'post_type'                   => 'ts_team',
                  'theme'                       => 'dark',
                  'priority'                    => 'high',
                  'context'                     => 'normal',
                  'show_restore'                => false,
                ));
                // Section - Basic Information
                CSF::createSection($prefix_page_opts, array(
                    'title'                     => 'Contact Information',
                    'icon'                      => 'fa fa-user',
                    'name'      			    => 'ts_vcsc_team_contact',
                    'fields'                    => array(
                        array(
                          'type'    		    => 'heading',
                          'content' 		    => 'Contact Information',
                        ),
                        array(
                            'type'    		    => 'submessage',
                            'style'   		    => 'warning',
                            'content' 		    => 'Use the "Featured Image" section to assign a photo of the team member. It is recommended to only use profile images that share the same scaling ratio; square images will work best.',
                        ),
                        array('id' => $prefixA . 'position', 'type' => 'text', 'title' => 'Position:', 'help' => 'Provide some information about the team members position in your company or group.'),
                        array('id' => $prefixB . 'email', 'type' => 'text', 'title' => '<i class="ts-teamicon-email3 ts-font-icon"></i> Email Address:', 'validate' => 'TS_VCSC_Codestar_Validate_Email',),
                        array('id' => $prefixB . 'phone', 'type' => 'text', 'title' => '<i class="ts-teamicon-phone2 ts-font-icon"></i> Phone Number:',),
                        array('id' => $prefixB . 'cell', 'type' => 'text','title' => '<i class="ts-teamicon-mobile ts-font-icon"></i> Cell Number:',),
                        array('id' => $prefixB . 'portfolio', 'type' => 'text','title' => '<i class="ts-teamicon-portfolio ts-font-icon"></i> Portfolio URL:', 'validate' => 'TS_VCSC_Codestar_Validate_URL',),
                        array('id' => $prefixB . 'portfoliolabel', 'type' => 'text', 'title' => 'Label for Portfolio URL:', 'std' => '', 'help' => 'If left empty, the actual URL to the portfolio site will be shown.'),
                        array('id' => $prefixB . 'other','type' => 'text','title' => '<i class="ts-teamicon-link ts-font-icon"></i> Personal URL:', 'validate' => 'TS_VCSC_Codestar_Validate_URL',),
                        array('id' => $prefixB . 'otherlabel', 'type' => 'text', 'title' => 'Label for Personal URL:', 'std' => '', 'help' => 'If left empty, the actual URL to the personal site will be shown.'),
                        array('id' => $prefixB . 'skype', 'type' => 'text', 'title' => '<i class="ts-teamicon-skype ts-font-icon"></i> Skype User Name:',),
                    )
                ));
                // Section - Social Networks
                CSF::createSection($prefix_page_opts, array(
                    'title'                     => 'Social Networks',
                    'icon'                      => 'fa fa-share-square-o',
                    'name'      			    => 'ts_vcsc_team_social',
                    'fields'                    => array(
                        array(
                          'type'    		    => 'heading',
                          'content' 		    => 'Social Networks',
                        ),
                        array(
                            'type'    		    => 'submessage',
                            'style'   		    => 'info',
                            'content' 		    => 'Use the inputs below to provide links to profiles on social networks the team member might be using.',
                        ),
                        array('title' => '<i class="ts-teamicon-facebook1 ts-font-icon"></i> Facebook URL:', 'std' => '', 'desc' => '', 'id' => $prefixC . 'facebook', 'type' => 'text'),
                        array('title' => '<i class="ts-teamicon-googleplus1 ts-font-icon"></i> Google+ URL:', 'std' => '', 'desc' => '', 'id' => $prefixC . 'google', 'type' => 'text'),
                        array('title' => '<i class="ts-teamicon-twitter1 ts-font-icon"></i> Twitter URL:', 'std' => '', 'desc' => '', 'id' => $prefixC . 'twitter', 'type' => 'text'),
                        array('title' => '<i class="ts-teamicon-linkedin ts-font-icon"></i> Linkedin URL:', 'std' => '', 'desc' => '', 'id' => $prefixC . 'linkedin', 'type' => 'text'),
                        array('title' => '<i class="ts-teamicon-xing3 ts-font-icon"></i> Xing URL:', 'std' => '', 'desc' => '', 'id' => $prefixC . 'xing', 'type' => 'text'),
                        array('title' => '<i class="ts-teamicon-envato ts-font-icon"></i> Envato URL:', 'std' => '', 'desc' => '', 'id' => $prefixC . 'envato', 'type' => 'text'),
                        array('title' => '<i class="ts-teamicon-rss1 ts-font-icon"></i> RSS URL:', 'std' => '', 'desc' => '', 'id' => $prefixC . 'rss', 'type' => 'text'),
                        array('title' => '<i class="ts-teamicon-forrst1 ts-font-icon"></i> Forrst URL:', 'std' => '', 'desc' => '', 'id' => $prefixC . 'forrst', 'type' => 'text'),
                        array('title' => '<i class="ts-teamicon-flickr3 ts-font-icon"></i> Flickr URL:', 'std' => '', 'desc' => '', 'id' => $prefixC . 'flickr', 'type' => 'text'),
                        array('title' => '<i class="ts-teamicon-instagram ts-font-icon"></i> Instagram URL:', 'std' => '', 'desc' => '', 'id' => $prefixC . 'instagram', 'type' => 'text'),
                        array('title' => '<i class="ts-teamicon-picasa1 ts-font-icon"></i> Picasa URL:', 'std' => '', 'desc' => '', 'id' => $prefixC . 'picasa', 'type' => 'text'),
                        array('title' => '<i class="ts-teamicon-pinterest1 ts-font-icon"></i> Pinterest URL:', 'std' => '', 'desc' => '', 'id' => $prefixC . 'pinterest', 'type' => 'text'),
                        array('title' => '<i class="ts-teamicon-vimeo1 ts-font-icon"></i> Vimeo URL:', 'std' => '', 'desc' => '', 'id' => $prefixC . 'vimeo', 'type' => 'text'),
                        array('title' => '<i class="ts-teamicon-youtube1 ts-font-icon"></i> Youtube URL:', 'std' => '', 'desc' => '', 'id' => $prefixC . 'youtube', 'type' => 'text'),
                    )
                ));
                // Section - Skill Sets
                CSF::createSection($prefix_page_opts, array(
                    'title'                     => 'Member Skill Sets',
                    'icon'                      => 'fa fa-align-left',
                    'name'      			    => 'ts_vcsc_team_skills',
                    'fields'                    => array(
                        array(
                          'type'    		    => 'heading',
                          'content' 		    => 'Member Skill Sets',
                        ),
                        array(
                            'type'    		    => 'submessage',
                            'style'   		    => 'info',
                            'content' 		    => 'Add as many skill levels as you need by using the "Add New Skill" button. Skills can also be re-ordered by simply dragging them to their desired position, or removed by using the appropriate button within each skill set.',
                        ),
                        array(
                            'id'              	=> $prefixD . 'skillset',
                            'type'            	=> 'group',
                            'title'           	=> 'Skill Sets',
                            'button_title'    	=> 'Add New Skill',
                            'accordion_title' 	=> 'New Skill',
                            'fields'          	=> array(
                                array(
                                    'id'    	=> 'skillname',
                                    'type'  	=> 'text',
                                    'title' 	=> 'Skill Name:',
                                ),
                                array(
                                    'id'    	=> 'skillvalue',
                                    'type'  	=> 'slider',
                                    'title' 	=> 'Skill Value in %:',
                                    'min'       => 0,
                                    'max'       => 100,
                                    'step'      => 1,
                                    'unit'      => '%',
                                ),
                                array(
                                    'id'    	=> 'skillcolor',
                                    'type'  	=> 'color',
                                    'title' 	=> 'Skill Color:',
                                    'default'	=> '#00afd1',
                                ),
                            ),
                        ),
                    )
                ));
                // Section - Business / Opening Hours
                CSF::createSection($prefix_page_opts, array(
                    'title'                     => 'Business Information',
                    'icon'                      => 'fa fa-building-o',
                    'name'      			    => 'ts_vcsc_team_opening',
                    'fields'                    => array(
                        array(
                          'type'    		    => 'heading',
                          'content' 		    => 'Business Information',
                        ),
                        array(
                            'type'    		    => 'submessage',
                            'style'   		    => 'info',
                            'content' 		    => 'Use this section to provide additional information, such as business / opening hours, or other optional information. The matching elements in WP Bakery Page Builder will allow you to show or hide this section individually.',
                        ),
                        array(
                            'id'				=> $prefixD . 'symbol',
                            'type'				=> "iconpicker",
                            'title'    		    => 'Select Icon:',
                            'help'    		    => 'Select the icon that should be shown alongside the header.',	
                            'settings' 			=> array(
								"emptyIcon" 			=> true,
								"emptyIconValue"		=> 'transparent',
								"iconsPerPage"			=> 198,
                                "override"				=> true,
                                "hasSearch"             => false,
								"type" 					=> 'teambusiness',
                            ),
                            'attributes' 	    => array(
                                'data-depend-id'    => $prefixD . 'symbol',
                            ),
                            'default' 		    => 'ts-teamicon-clock1 ts-font-icon',
                        ),
                        array(
                            'id' 			    => $prefixD . 'symbolcolor',
                            'type' 			    => 'color',
                            'title' 		    => 'Icon Color:',
                            'default' 		    => '#666666',
                            'dependency'  	    => array($prefixD . 'symbol', '!=', 'none', true),
                        ),
                        array(
                            'id' 			    => $prefixD . 'header',
                            'type' 			    => 'text',
                            'title' 		    => 'Title:',
                            'help' 			    => 'Enter a header that will be shown above the custom content you will provide below.',
                        ),
                        array(
                            'id'       		    => $prefixD . 'opening',
                            'type'     		    => 'wp_editor',
                            'title'    		    => 'Information:',
                            'height'            => '150px',
                            'tinymce'           => false,
                            'media_buttons'     => false,
                            'help' 			    => 'You can use any text and basic HTML code; create line breaks via "Enter" button or by using the appropriate HTML code.',
                        ),
                    )
                ));
                // Section - Team Page Link
                CSF::createSection($prefix_page_opts, array(
                    'title'                     => 'Member Page Link',
                    'icon'                      => 'fa fa-external-link',
                    'name'      			    => 'ts_vcsc_team_page',
                    'fields'                    => array(
                        array(
                          'type'    		    => 'heading',
                          'content' 		    => 'Member Page Link',
                        ),
                        array(
                            'type'    		    => 'submessage',
                            'style'   		    => 'info',
                            'content' 		    => 'When used in a slider, you might not want to show all data in the slider; so provide a link (button) to a page that shows the full profile. You can select whether to show or hide the link button in the individual elements settings later.',
                        ),
                        array(
                            'id'         	    => $prefixA . 'dedicatedpage',
                            'type'       	    => 'select',
                            'title'      	    => 'Dedicated Page:',
                            'options'    	    => $availablePages,
                            'desc' 			    => 'If existing, select a page that is dedicated to this particular team member.',
                            'default'		    => -1,
                            'chosen'      	    => true,
                        ),
                        array(
                            'id' 			    => $prefixA . 'dedicatedlink',
                            'type' 			    => 'text',
                            'title'			    => '<i class="ts-teamicon-link ts-font-icon"></i> External URL:',
                            'validate' 		    => 'TS_VCSC_Codestar_Validate_URL',
                            'dependency'   	    => array($prefixA . 'dedicatedpage', '==', 'external', true),
                        ),
                        array(
                            'id'    		    => $prefixA . 'dedicatedtarget',
                            'type'  		    => 'buttonswitch',
                            'title' 		    => 'Open in New Tab/Window:',
                            'default'		    => false,
                            'dependency'   	    => array($prefixA . 'dedicatedpage', '!=', '-1', true),
                        ),
                        array(
                            'id'				=> $prefixA . 'dedicatedicon',
                            'type'				=> "iconpicker",
                            'title'    		    => 'Button Icon:',
                            'help'    		    => 'Select the icon that should be shown alongside the button label.',
                            'settings' 			=> array(
								"emptyIcon" 			=> true,
								"emptyIconValue"		=> 'transparent',
								"iconsPerPage"			=> 198,
                                "override"				=> true,
                                "hasSearch"             => false,
								"type" 					=> 'teambutton',
                            ),
                            'attributes' 	    => array(
                                'data-depend-id'    => $prefixA . 'dedicatedicon',
                            ),
                            'default' 		    => 'ts-teamicon-eye2 ts-font-icon',
                            'dependency'   	    => array($prefixA . 'dedicatedpage', '!=', '-1', true),
                        ),
                        array(
                            'id' 			    => $prefixA . 'dedicatedcolor',
                            'type' 			    => 'color',
                            'title' 		    => 'Icon Color:',
                            'default' 		    => '#666666',
                            'dependency'  	    => array($prefixA . 'dedicatedicon|' . $prefixA . 'dedicatedpage', '!=|!=', 'none|-1', true),
                        ),
                        array(
                            'id' 			    => $prefixA . 'dedicatedlabel',
                            'type' 			    => 'text',
                            'title' 		    => 'Button Label:',
                            'default'		    => 'View Teammate',
                            'dependency'   	    => array($prefixA . 'dedicatedpage', '!=', '-1', true),
                        ),
                        array(
                            'id' 			    => $prefixA . 'dedicatedtooltip',
                            'type' 			    => 'text',
                            'title' 		    => 'Button Tooltip:',
                            'dependency'   	    => array($prefixA . 'dedicatedpage', '!=', '-1', true),
                        ),
                        array(
                            'id' 			    => $prefixA . 'dedicatedtype',
                            'type' 			    => 'select',
                            'options' 		    => $TS_VCSC_Button_Types,
                            'title' 		    => 'Button Type:',
                            'default' 		    => 'ts-button-3d',
                            'desc' 			    => '',
                            'dependency'   	    => array($prefixA . 'dedicatedpage', '!=', '-1', true),
                            'chosen'      	    => true,
                        ),
                    )
                ));
                // Section - File Attachment
                CSF::createSection($prefix_page_opts, array(
                    'title'                     => 'File Attachment',
                    'icon'                      => 'fa fa-download',
                    'name'      			    => 'ts_vcsc_team_file',
                    'fields'                    => array(
                        array(
                          'type'    		    => 'heading',
                          'content' 		    => 'File Attachment',
                        ),
                        array(
                            'type'    		    => 'submessage',
                            'style'   		    => 'info',
                            'content' 		    => 'If applicable, you can attach a download option to your team member; useful for resumes or other information you want to provide for your viewers.',
                        ),
                        array(
                            'id'                => $prefixA . 'buttonfile',
                            'type'              => 'upload',
                            'title'             => 'Attachment',
                            'button_title'      => 'Upload or Add',
                            'remove_title'      => 'Remove File',
                            'help' 			    => 'Attach a file, including information such as a resume, for your viewers to download.',
                        ),
                        array(
                            'id'				=> $prefixA . 'buttonicon',
                            'type'				=> "iconpicker",
                            'title'    		    => 'Button Icon:',
                            'help'    		    => 'Select the icon that should be shown alongside the button label.',
                            'settings' 			=> array(
								"emptyIcon" 			=> true,
								"emptyIconValue"		=> 'transparent',
								"iconsPerPage"			=> 198,
                                "override"				=> true,
                                "hasSearch"             => false,
								"type" 					=> 'teamattachment',
                            ),
                            'attributes' 	    => array(
                                'data-depend-id'    => $prefixA . 'buttonicon',
                            ),
                            'default' 		    => 'ts-teamicon-download3 ts-font-icon',
                            'dependency'   	    => array($prefixA . 'buttonfile', '!=', '', true),
                        ),
                        array(
                            'id' 			    => $prefixA . 'buttoncolor',
                            'type' 			    => 'color',
                            'title' 		    => 'Icon Color:',
                            'default' 		    => '#666666',
                            'dependency'  	    => array($prefixA . 'buttonicon|' . $prefixA . 'buttonfile', '!=|!=', 'none|', true),
                        ),
                        array(
                            'id' 			    => $prefixA . 'buttonlabel',
                            'type' 			    => 'text',
                            'title' 		    => 'Button Label:',
                            'default'		    => 'Download File',
                            'dependency'   	    => array($prefixA . 'buttonfile', '!=', '', true),
                        ),
                        array(
                            'id' 			    => $prefixA . 'buttontooltip',
                            'type' 			    => 'text',
                            'title' 		    => 'Button Tooltip:',
                            'dependency'   	    => array($prefixA . 'buttonfile', '!=', '', true),
                        ),
                        array(
                            'id' 			    => $prefixA . 'buttontype',
                            'type' 			    => 'select',
                            'options' 		    => $TS_VCSC_Button_Types,
                            'title' 		    => 'Button Type:',
                            'default' 		    => 'ts-button-3d',
                            'desc' 			    => '',
                            'dependency'   	    => array($prefixA . 'buttonfile', '!=', '', true),
                            'chosen'            => true,
                        ),
                    )
                ));
            }
		}
	}
	
	// Load Required JS+CSS Files
	function TS_VCSC_Team_Post_Files() {
		global $pagenow;		
		$screen = TS_VCSC_GetCurrentPostType();
		if ($screen == 'ts_team') {
			if ($pagenow == 'post-new.php' || $pagenow == 'post.php') {
				if (!wp_script_is('jquery')) {
					wp_enqueue_script('jquery');
				}
				wp_enqueue_style('ts-font-teammates');
				wp_enqueue_style('ts-extend-posttypes');
				wp_enqueue_script('ts-extend-posttypes');
			}
		}
	}
	
	// Remove RevSlider + Essential Grid Metaboxes
	function TS_VCSC_Team_RemoveExternalMetaboxes() { 
		global $pagenow;
		$screen = TS_VCSC_GetCurrentPostType();
		if ($screen=='ts_team') {
			if ($pagenow=='post-new.php' || $pagenow=='post.php') {
				remove_meta_box('eg-meta-box', 'ts_team', 'normal'); 
				remove_meta_box('mymetabox_revslider_0', 'ts_team', 'normal'); 
			} 
		} 
	}
    
    // Create Custom Columns
	function TS_VCSC_Team_Set_CustomColumn_PostType($defaults) {
		$defaults = array_merge(
            $defaults,
			array('previews'                            => _x('Thumbnail', 'ts_visual_composer_extend')),
            array('ids'                                 => _x('ID', 'ts_visual_composer_extend'))	
		);
		return $defaults;
	}
    
    // Pull Data for Custom Columns
	function TS_VCSC_Team_Get_CustomColumn_Data($columns, $post_id) {
		if ($columns === 'previews') {
			echo the_post_thumbnail('thumbnail');
		} else if ($columns === 'ids') {
            echo $post_id;
        }
	}
    
    // Create Custom Columns Styling
    function TS_VCSC_Team_AdjustColumnWidths() {
        echo '<style type="text/css">
            .column-previews {text-align: left; width: 175px !important; overflow: hidden;}
            .column-ids {text-align: left; width: 60px !important; overflow: hidden;}
        </style>';
    }
    
	// Make Customs Columns Sortable		
	function TS_VCSC_Team_Sort_CustomColumns($columns) {
		$columns['ids'] = 'ids';    
		return $columns;
	}
	
	// Call All Routines
	if (is_admin()) {
		add_filter('post_updated_messages', 						'TS_VCSC_Team_Post_Messages');
        //add_action('contextual_help', 							'TS_VCSC_Team_Post_HelpOld',            10, 3);
        add_action("load-edit.php", 								'TS_VCSC_Team_Post_HelpNew');        		
        add_action("load-post.php", 								'TS_VCSC_Team_Post_HelpNew');
        add_action("load-post-new.php",                             'TS_VCSC_Team_Post_HelpNew');
		add_filter('plugins_loaded',                                'TS_VCSC_Team_Codestar',                9999999999);
        add_action('admin_head',                                    'TS_VCSC_Team_AdjustColumnWidths');
        add_action('admin_enqueue_scripts', 						'TS_VCSC_Team_Post_Files', 				9999999999);
		add_action('add_meta_boxes', 								'TS_VCSC_Team_RemoveExternalMetaboxes', 9999999999);
		add_filter('manage_ts_team_posts_columns',                  'TS_VCSC_Team_Set_CustomColumn_PostType');
		add_action('manage_ts_team_posts_custom_column',            'TS_VCSC_Team_Get_CustomColumn_Data',   10, 2);
        add_filter('manage_edit-ts_team_sortable_columns',          'TS_VCSC_Team_Sort_CustomColumns');
	}
?>